import { Switch, Route } from "wouter";
import { queryClient } from "./lib/queryClient";
import { QueryClientProvider } from "@tanstack/react-query";
import { Toaster } from "@/components/ui/toaster";
import { TooltipProvider } from "@/components/ui/tooltip";
import { SidebarProvider, SidebarTrigger, SidebarInset } from "@/components/ui/sidebar";
import { AppSidebar } from "@/components/app-sidebar";
import { ThemeToggle } from "@/components/theme-toggle";
import NotFound from "@/pages/not-found";
import Dashboard from "@/pages/dashboard";
import SuppliersPage from "@/pages/suppliers";
import SupplierFormPage from "@/pages/supplier-form";
import SupplierDetailPage from "@/pages/supplier-detail";
import ProductsPage from "@/pages/products";
import ProductFormPage from "@/pages/product-form";
import UnitsPage from "@/pages/units";
import PurchaseInvoicesPage from "@/pages/purchase-invoices";
import PurchaseInvoiceFormPage from "@/pages/purchase-invoice-form";
import PurchaseInvoiceDetailPage from "@/pages/purchase-invoice-detail";
import PaymentsPage from "@/pages/payments";
import PurchaseDebitNotesPage from "@/pages/purchase-debit-notes";
import InventoryPage from "@/pages/inventory";
import JournalEntriesPage from "@/pages/journal-entries";
import ReportsPage from "@/pages/reports";
import SettingsPage from "@/pages/settings";
import ChartOfAccountsPage from "@/pages/chart-of-accounts";
import TrialBalancePage from "@/pages/trial-balance";
import GeneralLedgerPage from "@/pages/general-ledger";
import ServiceCategoriesPage from "@/pages/service-categories";
import ServicesPage from "@/pages/services";
import OrdersPage from "@/pages/orders";
import OrderNewPage from "@/pages/order-new";
import OrderDetailPage from "@/pages/order-detail";
import OrdersTodayPage from "@/pages/orders-today";
import OrdersAppPage from "@/pages/orders-app";
import OrdersCanceledPage from "@/pages/orders-canceled";
import OrdersPostponedPage from "@/pages/orders-postponed";
import OrdersScheduledPage from "@/pages/orders-scheduled";
import RolesPage from "@/pages/roles";
import EmployeesPage from "@/pages/employees";
import EmployeeDetailPage from "@/pages/employee-detail";
import EmployeeTasksPage from "@/pages/employee-tasks";
import SalaryProfilesPage from "@/pages/salary-profiles";
import PayrollPage from "@/pages/payroll";
import CafeteriaProductsPage from "@/pages/cafeteria-products";
import CafeteriaPurchasesPage from "@/pages/cafeteria-purchases";
import CafeteriaSalesPage from "@/pages/cafeteria-sales";
import CafeteriaInventoryPage from "@/pages/cafeteria-inventory";
import CafeteriaCustodiesPage from "@/pages/cafeteria-custodies";
import CafeteriaSalesPrintPage from "@/pages/cafeteria-sales-print";
import CustomersPage from "@/pages/customers";
import CustomerDetailPage from "@/pages/customer-detail";
import LoyaltySettingsPage from "@/pages/loyalty-settings";
import AppointmentsPage from "@/pages/appointments";
import AppointmentDetailPage from "@/pages/appointment-detail";
import NewAppointmentPage from "@/pages/new-appointment";
import PackagesPage from "@/pages/packages";
import CouponsPage from "@/pages/coupons";
import JobPositionsPage from "@/pages/job-positions";
import NationalitiesPage from "@/pages/nationalities";
import SupervisorsPage from "@/pages/supervisors";
import WorkShiftsPage from "@/pages/work-shifts";
import ShiftAssignmentsPage from "@/pages/shift-assignments";
import AttendancePage from "@/pages/attendance";
import OvertimePage from "@/pages/overtime";
import LeavesPage from "@/pages/leaves";
import AttendanceCheckPage from "@/pages/attendance-check";
import FinancialReportsPage from "@/pages/financial-reports";
import LoyaltyPointsPage from "@/pages/loyalty-points";
import ExpenseTypesPage from "@/pages/expense-types";
import ExpensesPage from "@/pages/expenses";
import PayablesPage from "@/pages/payables";
import EmployeeCustodiesPage from "@/pages/employee-custodies";
import DriversPage from "@/pages/drivers";
import CashDisbursementsPage from "@/pages/cash-disbursements";
import IncomeStatementPage from "@/pages/income-statement";
import BalanceSheetPage from "@/pages/balance-sheet";
import CashFlowPage from "@/pages/cash-flow";
import OrderPrintPage from "@/pages/order-print";
import InvoiceSettingsPage from "@/pages/invoice-settings";
import DailyReportPage from "@/pages/daily-report";
import MarketingReportsPage from "@/pages/marketing-reports";
import BrandsPage from "@/pages/brands";
import VatDeclarationPage from "@/pages/vat-declaration";
import CommissionsPage from "@/pages/commissions";
import CustomerReviewsPage from "@/pages/customer-reviews";
import EmployeeReportsPage from "@/pages/employee-reports";
import HRStatisticsPage from "@/pages/hr-statistics";
import InventoryWithdrawalsPage from "@/pages/inventory-withdrawals";

function Router() {
  return (
    <Switch>
      <Route path="/" component={Dashboard} />
      <Route path="/suppliers" component={SuppliersPage} />
      <Route path="/suppliers/new" component={SupplierFormPage} />
      <Route path="/suppliers/:id" component={SupplierDetailPage} />
      <Route path="/suppliers/:id/edit" component={SupplierFormPage} />
      <Route path="/products" component={ProductsPage} />
      <Route path="/products/new" component={ProductFormPage} />
      <Route path="/products/:id" component={ProductFormPage} />
      <Route path="/products/:id/edit" component={ProductFormPage} />
      <Route path="/brands" component={BrandsPage} />
      <Route path="/units" component={UnitsPage} />
      <Route path="/purchase-invoices" component={PurchaseInvoicesPage} />
      <Route path="/purchase-invoices/new" component={PurchaseInvoiceFormPage} />
      <Route path="/purchase-invoices/:id" component={PurchaseInvoiceDetailPage} />
      <Route path="/payments" component={PaymentsPage} />
      <Route path="/purchase-debit-notes" component={PurchaseDebitNotesPage} />
      <Route path="/inventory" component={InventoryPage} />
      <Route path="/inventory-withdrawals" component={InventoryWithdrawalsPage} />
      <Route path="/employee-custodies" component={EmployeeCustodiesPage} />
      <Route path="/journal-entries" component={JournalEntriesPage} />
      <Route path="/reports" component={ReportsPage} />
      <Route path="/settings" component={SettingsPage} />
      <Route path="/chart-of-accounts" component={ChartOfAccountsPage} />
      <Route path="/trial-balance" component={TrialBalancePage} />
      <Route path="/general-ledger" component={GeneralLedgerPage} />
      <Route path="/service-categories" component={ServiceCategoriesPage} />
      <Route path="/services" component={ServicesPage} />
      <Route path="/orders" component={OrdersPage} />
      <Route path="/orders/today" component={OrdersTodayPage} />
      <Route path="/orders/app" component={OrdersAppPage} />
      <Route path="/orders/canceled" component={OrdersCanceledPage} />
      <Route path="/orders/postponed" component={OrdersPostponedPage} />
      <Route path="/orders/scheduled" component={OrdersScheduledPage} />
      <Route path="/orders/new" component={OrderNewPage} />
      <Route path="/orders/:id" component={OrderDetailPage} />
      <Route path="/orders/:id/print" component={OrderPrintPage} />
      <Route path="/roles" component={RolesPage} />
      <Route path="/employees" component={EmployeesPage} />
      <Route path="/employees/:id" component={EmployeeDetailPage} />
      <Route path="/employee-tasks" component={EmployeeTasksPage} />
      <Route path="/salary-profiles" component={SalaryProfilesPage} />
      <Route path="/payroll" component={PayrollPage} />
      <Route path="/cafeteria/products" component={CafeteriaProductsPage} />
      <Route path="/cafeteria/purchases" component={CafeteriaPurchasesPage} />
      <Route path="/cafeteria/sales" component={CafeteriaSalesPage} />
      <Route path="/cafeteria/sales/:id/print" component={CafeteriaSalesPrintPage} />
      <Route path="/cafeteria/inventory" component={CafeteriaInventoryPage} />
      <Route path="/cafeteria/custodies" component={CafeteriaCustodiesPage} />
      <Route path="/customers" component={CustomersPage} />
      <Route path="/customers/loyalty-points" component={LoyaltyPointsPage} />
      <Route path="/customers/:id" component={CustomerDetailPage} />
      <Route path="/loyalty-settings" component={LoyaltySettingsPage} />
      <Route path="/packages" component={PackagesPage} />
      <Route path="/coupons" component={CouponsPage} />
      <Route path="/customer-reviews" component={CustomerReviewsPage} />
      <Route path="/appointments" component={AppointmentsPage} />
      <Route path="/appointments/today" component={AppointmentsPage} />
      <Route path="/appointments/app" component={AppointmentsPage} />
      <Route path="/appointments/pending" component={AppointmentsPage} />
      <Route path="/appointments/new" component={NewAppointmentPage} />
      <Route path="/appointments/:id" component={AppointmentDetailPage} />
      <Route path="/hr/job-positions" component={JobPositionsPage} />
      <Route path="/hr/nationalities" component={NationalitiesPage} />
      <Route path="/hr/supervisors" component={SupervisorsPage} />
      <Route path="/hr/work-shifts" component={WorkShiftsPage} />
      <Route path="/hr/shift-assignments" component={ShiftAssignmentsPage} />
      <Route path="/hr/attendance" component={AttendancePage} />
      <Route path="/hr/overtime" component={OvertimePage} />
      <Route path="/hr/leaves" component={LeavesPage} />
      <Route path="/hr/attendance-check" component={AttendanceCheckPage} />
      <Route path="/hr/reports" component={EmployeeReportsPage} />
      <Route path="/hr/statistics" component={HRStatisticsPage} />
      <Route path="/financial-reports" component={FinancialReportsPage} />
      <Route path="/vat-declaration" component={VatDeclarationPage} />
      <Route path="/income-statement" component={IncomeStatementPage} />
      <Route path="/balance-sheet" component={BalanceSheetPage} />
      <Route path="/cash-flow" component={CashFlowPage} />
      <Route path="/expenses/types" component={ExpenseTypesPage} />
      <Route path="/expenses" component={ExpensesPage} />
      <Route path="/payables" component={PayablesPage} />
      <Route path="/drivers" component={DriversPage} />
      <Route path="/cash-disbursements" component={CashDisbursementsPage} />
      <Route path="/invoice-settings" component={InvoiceSettingsPage} />
      <Route path="/daily-report" component={DailyReportPage} />
      <Route path="/marketing-reports" component={MarketingReportsPage} />
      <Route path="/commissions" component={CommissionsPage} />
      <Route component={NotFound} />
    </Switch>
  );
}

function App() {
  const sidebarStyle = {
    "--sidebar-width": "18rem",
    "--sidebar-width-icon": "4rem",
  };

  return (
    <QueryClientProvider client={queryClient}>
      <TooltipProvider>
        <SidebarProvider style={sidebarStyle as React.CSSProperties}>
          <div className="flex min-h-screen w-full">
            <AppSidebar />
            <SidebarInset className="flex flex-col flex-1">
              <header className="flex items-center justify-between gap-2 border-b px-4 py-3 sticky top-0 bg-background z-10">
                <SidebarTrigger data-testid="button-sidebar-toggle" />
                <ThemeToggle />
              </header>
              <main className="flex-1 p-6 overflow-auto">
                <Router />
              </main>
            </SidebarInset>
          </div>
        </SidebarProvider>
        <Toaster />
      </TooltipProvider>
    </QueryClientProvider>
  );
}

export default App;
