import { Link, useLocation } from "wouter";
import { useState } from "react";
import {
  Collapsible,
  CollapsibleContent,
  CollapsibleTrigger,
} from "@/components/ui/collapsible";
import {
  Sidebar,
  SidebarContent,
  SidebarGroup,
  SidebarGroupContent,
  SidebarGroupLabel,
  SidebarMenu,
  SidebarMenuButton,
  SidebarMenuItem,
  SidebarMenuSub,
  SidebarMenuSubButton,
  SidebarMenuSubItem,
  SidebarHeader,
  SidebarFooter,
} from "@/components/ui/sidebar";
import {
  LayoutDashboard,
  Users,
  Package,
  Ruler,
  FileText,
  CreditCard,
  Warehouse,
  BookOpen,
  BarChart3,
  Settings,
  Calculator,
  Scale,
  Layers,
  Scissors,
  Folder,
  ShoppingCart,
  Shield,
  UserCog,
  ClipboardList,
  Wallet,
  DollarSign,
  Coffee,
  Receipt,
  UserCircle,
  Gift,
  CalendarCheck,
  ChevronDown,
  Calendar,
  Smartphone,
  XCircle,
  Clock,
  CalendarClock,
  Star,
  MessageSquare,
  Ticket,
  Megaphone,
  Briefcase,
  Globe,
  UserCheck,
  Timer,
  CalendarDays,
  Fingerprint,
  ClockArrowUp,
  Palmtree,
  ScanLine,
  Coins,
  Car,
  Award,
  Percent,
  TrendingUp,
  PackageMinus,
} from "lucide-react";

// 1) Dashboard
const dashboardMenuItem = {
  title: "لوحة التحكم",
  url: "/",
  icon: LayoutDashboard,
};

// Salon Orders Submenu Items
const salonOrdersSubItems = [
  {
    title: "طلبات اليوم",
    url: "/orders/today",
    icon: Calendar,
  },
  {
    title: "طلبات",
    url: "/orders",
    icon: ShoppingCart,
  },
  {
    title: "طلبات التطبيق",
    url: "/orders/app",
    icon: Smartphone,
  },
  {
    title: "إلغاء الطلب",
    url: "/orders/canceled",
    icon: XCircle,
  },
  {
    title: "الطلبات المؤجلة",
    url: "/orders/postponed",
    icon: Clock,
  },
  {
    title: "الطلبات المجدولة",
    url: "/orders/scheduled",
    icon: CalendarClock,
  },
  {
    title: "تقييمات",
    url: "/orders/ratings",
    icon: Star,
  },
  {
    title: "اسباب التقييمات",
    url: "/orders/rating-reasons",
    icon: MessageSquare,
  },
];

// Appointments Submenu Items
const appointmentsSubItems = [
  {
    title: "حجوزات اليوم",
    url: "/appointments/today",
    icon: Calendar,
  },
  {
    title: "الحجوزات",
    url: "/appointments",
    icon: CalendarCheck,
  },
  {
    title: "حجوزات التطبيق",
    url: "/appointments/app",
    icon: Smartphone,
  },
  {
    title: "الحجوزات المعلقة",
    url: "/appointments/pending",
    icon: Clock,
  },
];

// 2) Sales (المبيعات) - Orders and Appointments only
const salesMenuItems: { title: string; url: string; icon: typeof UserCircle }[] = [];

// 3) Marketing (التسويق) - Packages, Coupons, Loyalty Settings
const marketingMenuItems = [
  {
    title: "الحزم",
    url: "/packages",
    icon: Package,
  },
  {
    title: "الكوبونات",
    url: "/coupons",
    icon: Ticket,
  },
  {
    title: "تقييمات العملاء",
    url: "/customer-reviews",
    icon: MessageSquare,
  },
  {
    title: "إعدادات الولاء",
    url: "/loyalty-settings",
    icon: Gift,
  },
  {
    title: "تقارير التسويق",
    url: "/marketing-reports",
    icon: BarChart3,
  },
];

// 4) Customers (عملاء) - Customer list and Loyalty Points
const customersMenuItems = [
  {
    title: "عملاء",
    url: "/customers",
    icon: UserCircle,
  },
  {
    title: "نقاط العملاء",
    url: "/customers/loyalty-points",
    icon: Coins,
  },
];

// 5) Cafeteria (الكافتيريا)
const cafeteriaMenuItems = [
  {
    title: "منتجات الكافتريا",
    url: "/cafeteria/products",
    icon: Coffee,
  },
  {
    title: "مشتريات الكافتريا",
    url: "/cafeteria/purchases",
    icon: ShoppingCart,
  },
  {
    title: "مبيعات الكافتريا",
    url: "/cafeteria/sales",
    icon: Receipt,
  },
  {
    title: "مخزون",
    url: "/cafeteria/inventory",
    icon: Warehouse,
  },
  {
    title: "عهد الموظفين",
    url: "/cafeteria/custodies",
    icon: Package,
  },
];

// 5) Services (الخدمات)
const servicesMenuItems = [
  {
    title: "فئات الخدمات",
    url: "/service-categories",
    icon: Folder,
  },
  {
    title: "الخدمات",
    url: "/services",
    icon: Scissors,
  },
];

// 6) Purchases (المشتريات)
const purchasesMenuItems = [
  {
    title: "الموردين",
    url: "/suppliers",
    icon: Users,
  },
  {
    title: "فواتير المشتريات",
    url: "/purchase-invoices",
    icon: FileText,
  },
  {
    title: "مدفوعات المشتريات",
    url: "/payments",
    icon: CreditCard,
  },
  {
    title: "إشعارات الخصم",
    url: "/purchase-debit-notes",
    icon: Receipt,
  },
  {
    title: "الديون والمستحقات",
    url: "/payables",
    icon: Clock,
  },
];

// 7) Inventory (المخزون)
const inventoryMenuItems = [
  {
    title: "المنتجات",
    url: "/products",
    icon: Package,
  },
  {
    title: "العلامات التجارية",
    url: "/brands",
    icon: Award,
  },
  {
    title: "وحدات القياس",
    url: "/units",
    icon: Ruler,
  },
  {
    title: "حركة المخزون",
    url: "/inventory",
    icon: Warehouse,
  },
  {
    title: "أوامر السحب",
    url: "/inventory-withdrawals",
    icon: PackageMinus,
  },
  {
    title: "عهدة الموظفين",
    url: "/employee-custodies",
    icon: UserCog,
  },
  {
    title: "تقارير المخزون",
    url: "/reports",
    icon: BarChart3,
  },
];

// 8) Employees (الموظفين)
const employeesMenuItems = [
  {
    title: "الأدوار",
    url: "/roles",
    icon: Shield,
  },
  {
    title: "الموظفين",
    url: "/employees",
    icon: UserCog,
  },
  {
    title: "المشرفين",
    url: "/hr/supervisors",
    icon: UserCheck,
  },
  {
    title: "مهام",
    url: "/employee-tasks",
    icon: ClipboardList,
  },
  {
    title: "الوظائف",
    url: "/hr/job-positions",
    icon: Briefcase,
  },
  {
    title: "الجنسيات",
    url: "/hr/nationalities",
    icon: Globe,
  },
];

// 9) HR (الموارد البشرية)
// Drivers menu item
const driversMenuItem = {
  title: "السائقون",
  url: "/drivers",
  icon: Car,
};

const hrMenuItems = [
  {
    title: "الورديات",
    url: "/hr/work-shifts",
    icon: Timer,
  },
  {
    title: "مناوبات الموظفين",
    url: "/hr/shift-assignments",
    icon: CalendarDays,
  },
  {
    title: "الحضور",
    url: "/hr/attendance-check",
    icon: ScanLine,
  },
  {
    title: "سجل الحضور",
    url: "/hr/attendance",
    icon: Fingerprint,
  },
  {
    title: "الوقت الإضافي",
    url: "/hr/overtime",
    icon: ClockArrowUp,
  },
  {
    title: "الرواتب",
    url: "/salary-profiles",
    icon: Wallet,
  },
  {
    title: "الرواتب المولدة",
    url: "/payroll",
    icon: DollarSign,
  },
  {
    title: "العمولات",
    url: "/commissions",
    icon: Percent,
  },
  {
    title: "الإجازات",
    url: "/hr/leaves",
    icon: Palmtree,
  },
  {
    title: "تقارير الموظفين",
    url: "/hr/reports",
    icon: FileText,
  },
  {
    title: "إحصائيات الموارد البشرية",
    url: "/hr/statistics",
    icon: TrendingUp,
  },
];

// 10) Expenses (النفقات)
const expensesMenuItems = [
  {
    title: "أنواع النفقات",
    url: "/expenses/types",
    icon: Folder,
  },
  {
    title: "النفقات",
    url: "/expenses",
    icon: Receipt,
  },
];

// 11) Finance (المالية)
const financeMenuItems = [
  {
    title: "تقرير اليومية",
    url: "/daily-report",
    icon: Receipt,
  },
  {
    title: "القيود اليومية",
    url: "/journal-entries",
    icon: BookOpen,
  },
  {
    title: "الحسابات",
    url: "/chart-of-accounts",
    icon: Layers,
  },
  {
    title: "التقارير المالية",
    url: "/financial-reports",
    icon: BarChart3,
  },
  {
    title: "صرف نقدي",
    url: "/cash-disbursements",
    icon: Coins,
  },
  {
    title: "إعدادات الفاتورة",
    url: "/invoice-settings",
    icon: FileText,
  },
];

export function AppSidebar() {
  const [location] = useLocation();
  const [ordersOpen, setOrdersOpen] = useState(true);
  const [appointmentsOpen, setAppointmentsOpen] = useState(true);
  const [marketingOpen, setMarketingOpen] = useState(false);
  const [customersOpen, setCustomersOpen] = useState(false);
  const [cafeteriaOpen, setCafeteriaOpen] = useState(false);
  const [servicesOpen, setServicesOpen] = useState(false);
  const [purchasesOpen, setPurchasesOpen] = useState(false);
  const [inventoryOpen, setInventoryOpen] = useState(false);
  const [employeesOpen, setEmployeesOpen] = useState(false);
  const [hrOpen, setHrOpen] = useState(false);
  const [expensesOpen, setExpensesOpen] = useState(false);
  const [financeOpen, setFinanceOpen] = useState(false);

  const isActiveRoute = (url: string) => {
    if (url === "/") return location === "/";
    return location === url || location.startsWith(url + "/");
  };

  const isOrdersActive = location.startsWith("/orders");
  const isAppointmentsActive = location.startsWith("/appointments");
  const isMarketingActive = ["/packages", "/coupons", "/customer-reviews", "/loyalty-settings", "/marketing-reports"].some(p => location.startsWith(p));
  const isCustomersActive = location.startsWith("/customers");
  const isCafeteriaActive = location.startsWith("/cafeteria");
  const isServicesActive = ["/service-categories", "/services"].some(p => location.startsWith(p));
  const isPurchasesActive = ["/suppliers", "/purchase-invoices", "/payments", "/payables"].some(p => location.startsWith(p));
  const isInventoryActive = ["/products", "/brands", "/units", "/inventory", "/reports", "/employee-custodies"].some(p => location === p || location.startsWith(p + "/"));
  const isEmployeesActive = ["/roles", "/employees", "/employee-tasks", "/hr/supervisors", "/hr/job-positions", "/hr/nationalities"].some(p => location.startsWith(p));
  const isHrActive = ["/hr/work-shifts", "/hr/shift-assignments", "/hr/attendance-check", "/hr/attendance", "/hr/overtime", "/salary-profiles", "/payroll", "/commissions", "/hr/leaves"].some(p => location.startsWith(p));
  const isExpensesActive = location.startsWith("/expenses");
  const isFinanceActive = ["/daily-report", "/journal-entries", "/chart-of-accounts", "/financial-reports", "/general-ledger", "/trial-balance", "/cash-disbursements", "/invoice-settings"].some(p => location.startsWith(p));

  return (
    <Sidebar side="right" collapsible="icon">
      <SidebarHeader className="border-b border-sidebar-border p-4">
        <div className="flex flex-col items-center justify-center gap-2 group-data-[collapsible=icon]:gap-0">
          <img 
            src="https://qamaretolv.softlix.net/assets/imgs/logo.svg" 
            alt="Q-Samaya Logo" 
            className="w-20 h-auto object-contain mx-auto group-data-[collapsible=icon]:w-8"
          />
          <div className="text-center group-data-[collapsible=icon]:hidden">
            <div className="font-bold text-lg bg-gradient-to-l from-primary to-accent bg-clip-text text-transparent">Q-Samaya</div>
            <div className="text-xs text-muted-foreground">نظام إدارة صالون</div>
          </div>
        </div>
      </SidebarHeader>

      <SidebarContent>
        {/* 1) Dashboard */}
        <SidebarGroup>
          <SidebarGroupContent>
            <SidebarMenu>
              <SidebarMenuItem>
                <SidebarMenuButton
                  asChild
                  isActive={location === dashboardMenuItem.url}
                  tooltip={dashboardMenuItem.title}
                  data-testid="nav-dashboard"
                >
                  <Link href={dashboardMenuItem.url}>
                    <dashboardMenuItem.icon className="h-4 w-4" />
                    <span>{dashboardMenuItem.title}</span>
                  </Link>
                </SidebarMenuButton>
              </SidebarMenuItem>
            </SidebarMenu>
          </SidebarGroupContent>
        </SidebarGroup>

        {/* 2) Sales - DO NOT MODIFY */}
        <SidebarGroup>
          <SidebarGroupLabel>المبيعات</SidebarGroupLabel>
          <SidebarGroupContent>
            <SidebarMenu>
              {/* Collapsible Salon Orders */}
              <Collapsible
                open={ordersOpen}
                onOpenChange={setOrdersOpen}
                className="group/collapsible"
              >
                <SidebarMenuItem>
                  <CollapsibleTrigger asChild>
                    <SidebarMenuButton
                      tooltip="طلبات الصالون"
                      isActive={isOrdersActive}
                      data-testid="nav-orders-toggle"
                    >
                      <ShoppingCart className="h-4 w-4" />
                      <span>طلبات الصالون</span>
                      <ChevronDown className="mr-auto h-4 w-4 transition-transform duration-200 group-data-[state=open]/collapsible:rotate-180" />
                    </SidebarMenuButton>
                  </CollapsibleTrigger>
                  <CollapsibleContent>
                    <SidebarMenuSub>
                      {salonOrdersSubItems.map((item) => (
                        <SidebarMenuSubItem key={item.title}>
                          <SidebarMenuSubButton
                            asChild
                            isActive={location === item.url}
                            data-testid={`nav-${item.url.replace(/\//g, "-").slice(1)}`}
                          >
                            <Link href={item.url}>
                              <item.icon className="h-4 w-4" />
                              <span>{item.title}</span>
                            </Link>
                          </SidebarMenuSubButton>
                        </SidebarMenuSubItem>
                      ))}
                    </SidebarMenuSub>
                  </CollapsibleContent>
                </SidebarMenuItem>
              </Collapsible>

              {/* Collapsible Appointments */}
              <Collapsible
                open={appointmentsOpen}
                onOpenChange={setAppointmentsOpen}
                className="group/collapsible-appointments"
              >
                <SidebarMenuItem>
                  <CollapsibleTrigger asChild>
                    <SidebarMenuButton
                      tooltip="الحجوزات"
                      isActive={isAppointmentsActive}
                      data-testid="nav-appointments-toggle"
                    >
                      <CalendarCheck className="h-4 w-4" />
                      <span>الحجوزات</span>
                      <ChevronDown className="mr-auto h-4 w-4 transition-transform duration-200 group-data-[state=open]/collapsible-appointments:rotate-180" />
                    </SidebarMenuButton>
                  </CollapsibleTrigger>
                  <CollapsibleContent>
                    <SidebarMenuSub>
                      {appointmentsSubItems.map((item) => (
                        <SidebarMenuSubItem key={item.title}>
                          <SidebarMenuSubButton
                            asChild
                            isActive={location === item.url}
                            data-testid={`nav-${item.url.replace(/\//g, "-").slice(1)}`}
                          >
                            <Link href={item.url}>
                              <item.icon className="h-4 w-4" />
                              <span>{item.title}</span>
                            </Link>
                          </SidebarMenuSubButton>
                        </SidebarMenuSubItem>
                      ))}
                    </SidebarMenuSub>
                  </CollapsibleContent>
                </SidebarMenuItem>
              </Collapsible>

              {/* Other Sales Items */}
              {salesMenuItems.map((item) => (
                <SidebarMenuItem key={item.title}>
                  <SidebarMenuButton
                    asChild
                    isActive={isActiveRoute(item.url)}
                    tooltip={item.title}
                    data-testid={`nav-${item.url.replace("/", "")}`}
                  >
                    <Link href={item.url}>
                      <item.icon className="h-4 w-4" />
                      <span>{item.title}</span>
                    </Link>
                  </SidebarMenuButton>
                </SidebarMenuItem>
              ))}
            </SidebarMenu>
          </SidebarGroupContent>
        </SidebarGroup>

        {/* 3) Marketing (التسويق) - Collapsible */}
        <SidebarGroup>
          <SidebarGroupContent>
            <SidebarMenu>
              <Collapsible
                open={marketingOpen}
                onOpenChange={setMarketingOpen}
                className="group/collapsible-marketing"
              >
                <SidebarMenuItem>
                  <CollapsibleTrigger asChild>
                    <SidebarMenuButton
                      tooltip="التسويق"
                      isActive={isMarketingActive}
                      data-testid="nav-marketing-toggle"
                    >
                      <Megaphone className="h-4 w-4" />
                      <span>التسويق</span>
                      <ChevronDown className="mr-auto h-4 w-4 transition-transform duration-200 group-data-[state=open]/collapsible-marketing:rotate-180" />
                    </SidebarMenuButton>
                  </CollapsibleTrigger>
                  <CollapsibleContent>
                    <SidebarMenuSub>
                      {marketingMenuItems.map((item) => (
                        <SidebarMenuSubItem key={item.title}>
                          <SidebarMenuSubButton
                            asChild
                            isActive={location === item.url || location.startsWith(item.url + "/")}
                            data-testid={`nav-${item.url.replace("/", "")}`}
                          >
                            <Link href={item.url}>
                              <item.icon className="h-4 w-4" />
                              <span>{item.title}</span>
                            </Link>
                          </SidebarMenuSubButton>
                        </SidebarMenuSubItem>
                      ))}
                    </SidebarMenuSub>
                  </CollapsibleContent>
                </SidebarMenuItem>
              </Collapsible>
            </SidebarMenu>
          </SidebarGroupContent>
        </SidebarGroup>

        {/* 4) Customers (عملاء) - Collapsible */}
        <SidebarGroup>
          <SidebarGroupContent>
            <SidebarMenu>
              <Collapsible
                open={customersOpen}
                onOpenChange={setCustomersOpen}
                className="group/collapsible-customers"
              >
                <SidebarMenuItem>
                  <CollapsibleTrigger asChild>
                    <SidebarMenuButton
                      tooltip="عملاء"
                      isActive={isCustomersActive}
                      data-testid="nav-customers-toggle"
                    >
                      <Users className="h-4 w-4" />
                      <span>عملاء</span>
                      <ChevronDown className="mr-auto h-4 w-4 transition-transform duration-200 group-data-[state=open]/collapsible-customers:rotate-180" />
                    </SidebarMenuButton>
                  </CollapsibleTrigger>
                  <CollapsibleContent>
                    <SidebarMenuSub>
                      {customersMenuItems.map((item) => (
                        <SidebarMenuSubItem key={item.title}>
                          <SidebarMenuSubButton
                            asChild
                            isActive={location === item.url || location.startsWith(item.url + "/")}
                            data-testid={`nav-${item.url.replace(/\//g, "-").slice(1)}`}
                          >
                            <Link href={item.url}>
                              <item.icon className="h-4 w-4" />
                              <span>{item.title}</span>
                            </Link>
                          </SidebarMenuSubButton>
                        </SidebarMenuSubItem>
                      ))}
                    </SidebarMenuSub>
                  </CollapsibleContent>
                </SidebarMenuItem>
              </Collapsible>
            </SidebarMenu>
          </SidebarGroupContent>
        </SidebarGroup>

        {/* 5) Cafeteria (الكافتريا) - Collapsible */}
        <SidebarGroup>
          <SidebarGroupContent>
            <SidebarMenu>
              <Collapsible
                open={cafeteriaOpen}
                onOpenChange={setCafeteriaOpen}
                className="group/collapsible-cafeteria"
              >
                <SidebarMenuItem>
                  <CollapsibleTrigger asChild>
                    <SidebarMenuButton
                      tooltip="الكافتريا"
                      isActive={isCafeteriaActive}
                      data-testid="nav-cafeteria-toggle"
                    >
                      <Coffee className="h-4 w-4" />
                      <span>الكافتريا</span>
                      <ChevronDown className="mr-auto h-4 w-4 transition-transform duration-200 group-data-[state=open]/collapsible-cafeteria:rotate-180" />
                    </SidebarMenuButton>
                  </CollapsibleTrigger>
                  <CollapsibleContent>
                    <SidebarMenuSub>
                      {cafeteriaMenuItems.map((item) => (
                        <SidebarMenuSubItem key={item.title}>
                          <SidebarMenuSubButton
                            asChild
                            isActive={location === item.url || location.startsWith(item.url + "/")}
                            data-testid={`nav-${item.url.replace(/\//g, "-").slice(1)}`}
                          >
                            <Link href={item.url}>
                              <item.icon className="h-4 w-4" />
                              <span>{item.title}</span>
                            </Link>
                          </SidebarMenuSubButton>
                        </SidebarMenuSubItem>
                      ))}
                    </SidebarMenuSub>
                  </CollapsibleContent>
                </SidebarMenuItem>
              </Collapsible>
            </SidebarMenu>
          </SidebarGroupContent>
        </SidebarGroup>

        {/* 5) Services (الخدمات) - Collapsible */}
        <SidebarGroup>
          <SidebarGroupContent>
            <SidebarMenu>
              <Collapsible
                open={servicesOpen}
                onOpenChange={setServicesOpen}
                className="group/collapsible-services"
              >
                <SidebarMenuItem>
                  <CollapsibleTrigger asChild>
                    <SidebarMenuButton
                      tooltip="الخدمات"
                      isActive={isServicesActive}
                      data-testid="nav-services-toggle"
                    >
                      <Scissors className="h-4 w-4" />
                      <span>الخدمات</span>
                      <ChevronDown className="mr-auto h-4 w-4 transition-transform duration-200 group-data-[state=open]/collapsible-services:rotate-180" />
                    </SidebarMenuButton>
                  </CollapsibleTrigger>
                  <CollapsibleContent>
                    <SidebarMenuSub>
                      {servicesMenuItems.map((item) => (
                        <SidebarMenuSubItem key={item.title}>
                          <SidebarMenuSubButton
                            asChild
                            isActive={location === item.url || location.startsWith(item.url + "/")}
                            data-testid={`nav-${item.url.replace("/", "")}`}
                          >
                            <Link href={item.url}>
                              <item.icon className="h-4 w-4" />
                              <span>{item.title}</span>
                            </Link>
                          </SidebarMenuSubButton>
                        </SidebarMenuSubItem>
                      ))}
                    </SidebarMenuSub>
                  </CollapsibleContent>
                </SidebarMenuItem>
              </Collapsible>
            </SidebarMenu>
          </SidebarGroupContent>
        </SidebarGroup>

        {/* 6) Purchases (المشتريات) - Collapsible */}
        <SidebarGroup>
          <SidebarGroupContent>
            <SidebarMenu>
              <Collapsible
                open={purchasesOpen}
                onOpenChange={setPurchasesOpen}
                className="group/collapsible-purchases"
              >
                <SidebarMenuItem>
                  <CollapsibleTrigger asChild>
                    <SidebarMenuButton
                      tooltip="المشتريات"
                      isActive={isPurchasesActive}
                      data-testid="nav-purchases-toggle"
                    >
                      <ShoppingCart className="h-4 w-4" />
                      <span>المشتريات</span>
                      <ChevronDown className="mr-auto h-4 w-4 transition-transform duration-200 group-data-[state=open]/collapsible-purchases:rotate-180" />
                    </SidebarMenuButton>
                  </CollapsibleTrigger>
                  <CollapsibleContent>
                    <SidebarMenuSub>
                      {purchasesMenuItems.map((item) => (
                        <SidebarMenuSubItem key={item.title}>
                          <SidebarMenuSubButton
                            asChild
                            isActive={location === item.url || location.startsWith(item.url + "/")}
                            data-testid={`nav-${item.url.replace("/", "")}`}
                          >
                            <Link href={item.url}>
                              <item.icon className="h-4 w-4" />
                              <span>{item.title}</span>
                            </Link>
                          </SidebarMenuSubButton>
                        </SidebarMenuSubItem>
                      ))}
                    </SidebarMenuSub>
                  </CollapsibleContent>
                </SidebarMenuItem>
              </Collapsible>
            </SidebarMenu>
          </SidebarGroupContent>
        </SidebarGroup>

        {/* 7) Inventory (المخزون) - Collapsible */}
        <SidebarGroup>
          <SidebarGroupContent>
            <SidebarMenu>
              <Collapsible
                open={inventoryOpen}
                onOpenChange={setInventoryOpen}
                className="group/collapsible-inventory"
              >
                <SidebarMenuItem>
                  <CollapsibleTrigger asChild>
                    <SidebarMenuButton
                      tooltip="المخزون"
                      isActive={isInventoryActive}
                      data-testid="nav-inventory-toggle"
                    >
                      <Warehouse className="h-4 w-4" />
                      <span>المخزون</span>
                      <ChevronDown className="mr-auto h-4 w-4 transition-transform duration-200 group-data-[state=open]/collapsible-inventory:rotate-180" />
                    </SidebarMenuButton>
                  </CollapsibleTrigger>
                  <CollapsibleContent>
                    <SidebarMenuSub>
                      {inventoryMenuItems.map((item) => (
                        <SidebarMenuSubItem key={item.title}>
                          <SidebarMenuSubButton
                            asChild
                            isActive={location === item.url || location.startsWith(item.url + "/")}
                            data-testid={`nav-${item.url.replace("/", "")}`}
                          >
                            <Link href={item.url}>
                              <item.icon className="h-4 w-4" />
                              <span>{item.title}</span>
                            </Link>
                          </SidebarMenuSubButton>
                        </SidebarMenuSubItem>
                      ))}
                    </SidebarMenuSub>
                  </CollapsibleContent>
                </SidebarMenuItem>
              </Collapsible>
            </SidebarMenu>
          </SidebarGroupContent>
        </SidebarGroup>

        {/* 8) Employees (الموظفين) - Collapsible */}
        <SidebarGroup>
          <SidebarGroupContent>
            <SidebarMenu>
              <Collapsible
                open={employeesOpen}
                onOpenChange={setEmployeesOpen}
                className="group/collapsible-employees"
              >
                <SidebarMenuItem>
                  <CollapsibleTrigger asChild>
                    <SidebarMenuButton
                      tooltip="الموظفين"
                      isActive={isEmployeesActive}
                      data-testid="nav-employees-toggle"
                    >
                      <Users className="h-4 w-4" />
                      <span>الموظفين</span>
                      <ChevronDown className="mr-auto h-4 w-4 transition-transform duration-200 group-data-[state=open]/collapsible-employees:rotate-180" />
                    </SidebarMenuButton>
                  </CollapsibleTrigger>
                  <CollapsibleContent>
                    <SidebarMenuSub>
                      {employeesMenuItems.map((item) => (
                        <SidebarMenuSubItem key={item.title}>
                          <SidebarMenuSubButton
                            asChild
                            isActive={location === item.url || location.startsWith(item.url + "/")}
                            data-testid={`nav-${item.url.replace(/\//g, "-").slice(1)}`}
                          >
                            <Link href={item.url}>
                              <item.icon className="h-4 w-4" />
                              <span>{item.title}</span>
                            </Link>
                          </SidebarMenuSubButton>
                        </SidebarMenuSubItem>
                      ))}
                    </SidebarMenuSub>
                  </CollapsibleContent>
                </SidebarMenuItem>
              </Collapsible>
            </SidebarMenu>
          </SidebarGroupContent>
        </SidebarGroup>

        {/* 9) HR (الموارد البشرية) - Collapsible */}
        <SidebarGroup>
          <SidebarGroupContent>
            <SidebarMenu>
              <Collapsible
                open={hrOpen}
                onOpenChange={setHrOpen}
                className="group/collapsible-hr"
              >
                <SidebarMenuItem>
                  <CollapsibleTrigger asChild>
                    <SidebarMenuButton
                      tooltip="الموارد البشرية"
                      isActive={isHrActive}
                      data-testid="nav-hr-toggle"
                    >
                      <UserCog className="h-4 w-4" />
                      <span>الموارد البشرية</span>
                      <ChevronDown className="mr-auto h-4 w-4 transition-transform duration-200 group-data-[state=open]/collapsible-hr:rotate-180" />
                    </SidebarMenuButton>
                  </CollapsibleTrigger>
                  <CollapsibleContent>
                    <SidebarMenuSub>
                      {hrMenuItems.map((item) => (
                        <SidebarMenuSubItem key={item.title}>
                          <SidebarMenuSubButton
                            asChild
                            isActive={location === item.url || location.startsWith(item.url + "/")}
                            data-testid={`nav-${item.url.replace(/\//g, "-").slice(1)}`}
                          >
                            <Link href={item.url}>
                              <item.icon className="h-4 w-4" />
                              <span>{item.title}</span>
                            </Link>
                          </SidebarMenuSubButton>
                        </SidebarMenuSubItem>
                      ))}
                    </SidebarMenuSub>
                  </CollapsibleContent>
                </SidebarMenuItem>
              </Collapsible>
            </SidebarMenu>
          </SidebarGroupContent>
        </SidebarGroup>

        {/* 10) Drivers (السائقون) */}
        <SidebarGroup>
          <SidebarGroupContent>
            <SidebarMenu>
              <SidebarMenuItem>
                <SidebarMenuButton
                  asChild
                  tooltip={driversMenuItem.title}
                  isActive={location === driversMenuItem.url || location.startsWith(driversMenuItem.url + "/")}
                  data-testid="nav-drivers"
                >
                  <Link href={driversMenuItem.url}>
                    <driversMenuItem.icon className="h-4 w-4" />
                    <span>{driversMenuItem.title}</span>
                  </Link>
                </SidebarMenuButton>
              </SidebarMenuItem>
            </SidebarMenu>
          </SidebarGroupContent>
        </SidebarGroup>

        {/* 11) Expenses (النفقات) - Collapsible */}
        <SidebarGroup>
          <SidebarGroupContent>
            <SidebarMenu>
              <Collapsible
                open={expensesOpen}
                onOpenChange={setExpensesOpen}
                className="group/collapsible-expenses"
              >
                <SidebarMenuItem>
                  <CollapsibleTrigger asChild>
                    <SidebarMenuButton
                      tooltip="النفقات"
                      isActive={isExpensesActive}
                      data-testid="nav-expenses-toggle"
                    >
                      <Wallet className="h-4 w-4" />
                      <span>النفقات</span>
                      <ChevronDown className="mr-auto h-4 w-4 transition-transform duration-200 group-data-[state=open]/collapsible-expenses:rotate-180" />
                    </SidebarMenuButton>
                  </CollapsibleTrigger>
                  <CollapsibleContent>
                    <SidebarMenuSub>
                      {expensesMenuItems.map((item) => (
                        <SidebarMenuSubItem key={item.title}>
                          <SidebarMenuSubButton
                            asChild
                            isActive={location === item.url || location.startsWith(item.url + "/")}
                            data-testid={`nav-${item.url.replace(/\//g, "-").slice(1)}`}
                          >
                            <Link href={item.url}>
                              <item.icon className="h-4 w-4" />
                              <span>{item.title}</span>
                            </Link>
                          </SidebarMenuSubButton>
                        </SidebarMenuSubItem>
                      ))}
                    </SidebarMenuSub>
                  </CollapsibleContent>
                </SidebarMenuItem>
              </Collapsible>
            </SidebarMenu>
          </SidebarGroupContent>
        </SidebarGroup>

        {/* 11) Finance (المالية) - Collapsible */}
        <SidebarGroup>
          <SidebarGroupContent>
            <SidebarMenu>
              <Collapsible
                open={financeOpen}
                onOpenChange={setFinanceOpen}
                className="group/collapsible-finance"
              >
                <SidebarMenuItem>
                  <CollapsibleTrigger asChild>
                    <SidebarMenuButton
                      tooltip="المالية"
                      isActive={isFinanceActive}
                      data-testid="nav-finance-toggle"
                    >
                      <Calculator className="h-4 w-4" />
                      <span>المالية</span>
                      <ChevronDown className="mr-auto h-4 w-4 transition-transform duration-200 group-data-[state=open]/collapsible-finance:rotate-180" />
                    </SidebarMenuButton>
                  </CollapsibleTrigger>
                  <CollapsibleContent>
                    <SidebarMenuSub>
                      {financeMenuItems.map((item) => (
                        <SidebarMenuSubItem key={item.title}>
                          <SidebarMenuSubButton
                            asChild
                            isActive={location === item.url || location.startsWith(item.url + "/")}
                            data-testid={`nav-${item.url.replace("/", "")}`}
                          >
                            <Link href={item.url}>
                              <item.icon className="h-4 w-4" />
                              <span>{item.title}</span>
                            </Link>
                          </SidebarMenuSubButton>
                        </SidebarMenuSubItem>
                      ))}
                    </SidebarMenuSub>
                  </CollapsibleContent>
                </SidebarMenuItem>
              </Collapsible>
            </SidebarMenu>
          </SidebarGroupContent>
        </SidebarGroup>
      </SidebarContent>

      <SidebarFooter className="border-t border-sidebar-border p-4">
        <SidebarMenu>
          <SidebarMenuItem>
            <SidebarMenuButton
              asChild
              isActive={location === "/settings"}
              tooltip="الإعدادات"
              data-testid="nav-settings"
            >
              <Link href="/settings">
                <Settings className="h-4 w-4" />
                <span>الإعدادات</span>
              </Link>
            </SidebarMenuButton>
          </SidebarMenuItem>
        </SidebarMenu>
      </SidebarFooter>
    </Sidebar>
  );
}
