import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Link } from "wouter";
import {
  BarChart3,
  BookOpen,
  Scale,
  Calculator,
  FileText,
  TrendingUp,
  TrendingDown,
  DollarSign,
  Wallet,
  Building2,
  Receipt,
} from "lucide-react";

const reportLinks = [
  {
    title: "الإقرار الضريبي (ZATCA)",
    description: "تقرير ضريبة القيمة المضافة المتوافق مع هيئة الزكاة",
    icon: Receipt,
    url: "/vat-declaration",
    color: "text-primary",
  },
  {
    title: "قائمة الدخل",
    description: "تقرير الإيرادات والمصروفات وصافي الربح",
    icon: TrendingUp,
    url: "/income-statement",
    color: "text-green-600",
  },
  {
    title: "الميزانية العمومية",
    description: "قائمة المركز المالي - الأصول والخصوم وحقوق الملكية",
    icon: Building2,
    url: "/balance-sheet",
    color: "text-blue-600",
  },
  {
    title: "التدفقات النقدية",
    description: "تقرير حركة النقد والبنك",
    icon: Wallet,
    url: "/cash-flow",
    color: "text-purple-600",
  },
  {
    title: "ميزان المراجعة",
    description: "ملخص أرصدة جميع الحسابات",
    icon: Scale,
    url: "/trial-balance",
    color: "text-orange-600",
  },
  {
    title: "دفتر الأستاذ العام",
    description: "عرض جميع الحركات المالية لكل حساب",
    icon: BookOpen,
    url: "/general-ledger",
    color: "text-cyan-600",
  },
  {
    title: "القيود اليومية",
    description: "عرض وإدارة القيود المحاسبية",
    icon: FileText,
    url: "/journal-entries",
    color: "text-indigo-600",
  },
  {
    title: "دليل الحسابات",
    description: "إدارة شجرة الحسابات",
    icon: Calculator,
    url: "/chart-of-accounts",
    color: "text-amber-600",
  },
];

export default function FinancialReportsPage() {
  return (
    <div className="space-y-6">
      <div className="flex items-center justify-between">
        <div>
          <h1 className="text-2xl font-bold">التقارير المالية</h1>
          <p className="text-muted-foreground">
            الوصول السريع للتقارير والبيانات المالية
          </p>
        </div>
      </div>

      <div className="grid gap-4 md:grid-cols-4">
        <Card>
          <CardHeader className="flex flex-row items-center justify-between gap-2 space-y-0 pb-2">
            <CardTitle className="text-sm font-medium">الإيرادات</CardTitle>
            <TrendingUp className="h-4 w-4 text-green-500" />
          </CardHeader>
          <CardContent>
            <div className="text-2xl font-bold text-green-600" data-testid="text-revenue">
              --
            </div>
            <p className="text-xs text-muted-foreground">هذا الشهر</p>
          </CardContent>
        </Card>

        <Card>
          <CardHeader className="flex flex-row items-center justify-between gap-2 space-y-0 pb-2">
            <CardTitle className="text-sm font-medium">المصروفات</CardTitle>
            <TrendingDown className="h-4 w-4 text-red-500" />
          </CardHeader>
          <CardContent>
            <div className="text-2xl font-bold text-red-600" data-testid="text-expenses">
              --
            </div>
            <p className="text-xs text-muted-foreground">هذا الشهر</p>
          </CardContent>
        </Card>

        <Card>
          <CardHeader className="flex flex-row items-center justify-between gap-2 space-y-0 pb-2">
            <CardTitle className="text-sm font-medium">صافي الربح</CardTitle>
            <DollarSign className="h-4 w-4 text-blue-500" />
          </CardHeader>
          <CardContent>
            <div className="text-2xl font-bold text-blue-600" data-testid="text-profit">
              --
            </div>
            <p className="text-xs text-muted-foreground">هذا الشهر</p>
          </CardContent>
        </Card>

        <Card>
          <CardHeader className="flex flex-row items-center justify-between gap-2 space-y-0 pb-2">
            <CardTitle className="text-sm font-medium">عدد القيود</CardTitle>
            <FileText className="h-4 w-4 text-purple-500" />
          </CardHeader>
          <CardContent>
            <div className="text-2xl font-bold" data-testid="text-entries-count">
              --
            </div>
            <p className="text-xs text-muted-foreground">هذا الشهر</p>
          </CardContent>
        </Card>
      </div>

      <div className="grid gap-4 md:grid-cols-2 lg:grid-cols-3">
        {reportLinks.map((report) => (
          <Card key={report.url} className="hover-elevate cursor-pointer" data-testid={`card-${report.url.slice(1)}`}>
            <Link href={report.url}>
              <CardHeader>
                <CardTitle className="flex items-center gap-3">
                  <div className={`p-2 rounded-lg bg-muted ${report.color}`}>
                    <report.icon className="h-5 w-5" />
                  </div>
                  <div>
                    <div className="text-lg">{report.title}</div>
                    <div className="text-sm font-normal text-muted-foreground">
                      {report.description}
                    </div>
                  </div>
                </CardTitle>
              </CardHeader>
            </Link>
          </Card>
        ))}
      </div>

      <Card>
        <CardHeader>
          <CardTitle className="flex items-center gap-2">
            <BarChart3 className="h-5 w-5" />
            نظرة عامة على الأداء المالي
          </CardTitle>
        </CardHeader>
        <CardContent>
          <div className="flex items-center justify-center h-48 text-muted-foreground">
            <div className="text-center">
              <BarChart3 className="h-12 w-12 mx-auto mb-2 opacity-50" />
              <p>سيتم عرض الرسوم البيانية هنا</p>
            </div>
          </div>
        </CardContent>
      </Card>
    </div>
  );
}
