# Beauty Salon ERP - Design Guidelines
**Purchases + Inventory + Finance Module**

## Design Approach
**System Selected:** Material Design with enterprise ERP customization
**Justification:** Data-intensive business application requiring clarity, efficiency, and RTL Arabic support. Focus on usability over aesthetics, with clean information hierarchy for complex financial and inventory data.

---

## Core Design Principles
1. **RTL-First Design:** All layouts mirror for Arabic (right-to-left), with proper number formatting
2. **Information Clarity:** Dense data presentation without overwhelming users
3. **Workflow Efficiency:** Multi-step processes (create invoice → add items → payment) should feel seamless
4. **Consistent Patterns:** Reusable components across all modules for faster learning

---

## Typography
**Font Family:** Cairo (Google Fonts) - excellent Arabic support with professional appearance
- **Headers:** Cairo Bold (32px, 24px, 20px)
- **Body Text:** Cairo Regular (16px)
- **Table Data:** Cairo Medium (14px)
- **Labels/Captions:** Cairo Regular (12px, 14px)
- **Numbers/Currency:** Tabular numbers for alignment in financial columns

---

## Layout System
**Spacing Units:** Tailwind 4, 6, 8, 12, 16 units consistently
- Page padding: p-6 or p-8
- Card spacing: p-6
- Form field gaps: gap-4
- Section margins: mb-8 or mb-12
- Table cell padding: px-4 py-3

**Grid Structure:**
- Sidebar navigation: 240px fixed width (right side for RTL)
- Main content: Full remaining width with max-w-7xl container
- Forms: Single column on mobile, 2-column grid on desktop (grid-cols-2 gap-6)
- Data tables: Full width with horizontal scroll on mobile

---

## Component Library

### Navigation
**Sidebar (Right-aligned for RTL):**
- Fixed position with module icons + Arabic labels
- Active state: filled background
- Modules: الموردين (Suppliers), المنتجات (Products), فواتير الشراء (Purchase Invoices), المخزون (Inventory), المدفوعات (Payments)

**Top Bar:**
- Breadcrumb navigation (right-aligned)
- User profile/settings (left-aligned)
- Global search (centered)

### Forms & Inputs
**Input Fields:**
- Outlined style with RTL-aware placeholder text
- Label above input (14px, medium weight)
- Error messages below in red (12px)
- Required fields marked with asterisk (*)
- Consistent height: h-12 for all text inputs

**Complex Form Patterns:**
- **Inline Creation:** Modal overlay for "Create New Supplier" within invoice form
- **Dynamic Line Items:** Add/remove rows with clear (+) and (×) buttons
- **Multi-step Forms:** Stepper component for purchase invoice workflow

**Dropdowns:**
- Searchable for suppliers/products (with Arabic search)
- Show additional context (CR number, SKU) in gray text below main option
- "Create New" option at bottom of dropdown

### Data Tables
**Structure:**
- Sticky header row with sort indicators
- Alternating row backgrounds for readability
- Right-aligned actions column (edit/delete icons)
- Pagination controls at bottom (Arabic numerals)

**Key Columns Display:**
- ID numbers: Monospace font
- Dates: Hijri + Gregorian options
- Currency: SAR symbol, 2 decimal places, right-aligned
- Status badges: Colored pills (green=paid, yellow=partial, red=unpaid)

### Cards & Panels
**Summary Cards:**
- Used for dashboard metrics
- Large number display (32px) with icon
- Subtitle context below
- Subtle shadow elevation

**Detail Panels:**
- White background with border
- Section headers with divider lines
- Collapsible sections for complex data (e.g., supplier bank accounts)

### Buttons & Actions
**Primary Actions:** Filled buttons (e.g., "إنشاء فاتورة" / Create Invoice)
**Secondary Actions:** Outlined buttons
**Destructive:** Red outlined for delete
**Icon Buttons:** For table row actions
**Floating Action Button:** Bottom-left for quick "New Purchase Invoice" creation

### Status Indicators
- **Payment Status:** Badge/pill with color coding
- **Stock Levels:** Progress bar with threshold indicators (red=low stock)
- **Expiry Dates:** Warning badges for near-expiry items (within 30 days)

### Modals & Overlays
- Standard modal: 600px width for forms
- Full-screen modal: For complex invoice creation
- Side drawer: For filtering/advanced search (slides from right)

---

## Page-Specific Layouts

### Suppliers List Page
- Search bar + filters at top (city, type, active status)
- Data table with columns: الاسم (Name), رقم السجل (CR), الرقم الضريبي (VAT), المدينة (City), النوع (Type), الحالة (Status)
- "Create Supplier" FAB

### Purchase Invoice Creation
- Three-panel layout:
  1. Supplier selection (top section)
  2. Line items table (middle - expandable rows)
  3. Totals summary (left sidebar sticky)
- Tax type toggle per line (شامل/غير شامل/معفي)
- Conversion factor display: "1 كرتون = 12 حبة"

### Inventory Dashboard
- Grid of product cards with stock levels
- Filter by: category, low stock, near expiry
- Each card shows: product image placeholder, name, current stock (in sell units), expiry dates for batches

### Payment Entry Form
- Invoice summary at top (read-only)
- Payment method tabs (كاش / بنك / بطاقة)
- Amount input with remaining balance calculation
- Payment history table below

---

## Images
**Icons:** Material Icons (Arabic-compatible)
**Product Placeholders:** 200x200px squares with subtle gradient backgrounds
**No Hero Images:** This is an internal ERP tool - all pages are functional dashboards/forms

---

## Accessibility & RTL Considerations
- All flex/grid layouts use logical properties (start/end vs left/right)
- Form labels associated with inputs via proper HTML structure
- Keyboard navigation throughout (tab order follows RTL reading)
- Currency/numbers maintain LTR within RTL context
- Date pickers support Hijri calendar option