# Q-Samaya - Beauty Salon ERP System

## Overview

Q-Samaya is a comprehensive ERP system for beauty salons providing complete management for Sales, Purchases, Inventory, HR, and Finance, with Arabic-first (RTL) support. It streamlines operations by handling supplier relationships, flexible product tracking with unit conversions, purchase invoices, inventory with batch and expiry dates, payments, and automated double-entry accounting. The system aims to enhance efficiency, financial reporting, and operational control for salon owners.

## Brand Identity

- **Brand Name**: Q-Samaya
- **Primary Color**: Pink (#D93E8D / HSL 330 67% 55%)
- **Accent Color**: Purple (#8B5CF6 / HSL 262 89% 66%)
- **Logo**: Gradient SVG logo (client/src/assets/q-samaya-logo.svg)
- **Theme**: Pink/purple gradient theme throughout the application

## User Preferences

Preferred communication style: Simple, everyday language.

## System Architecture

### UI/UX
The system features an Arabic-first (RTL) design, utilizing Radix UI and shadcn/ui with Tailwind CSS for a modern, responsive interface. It employs the Cairo font and focuses on information-dense layouts, including form validation, toast notifications, modal dialogs, and data tables with search/filtering capabilities.

### Technical Implementation
- **Frontend**: React 18 with TypeScript and Vite, using Wouter for routing. State management is handled by TanStack Query for server state, React Hook Form with Zod for validation, and React hooks for local state.
- **Backend**: Node.js with Express.js and TypeScript (ESM modules). It provides RESTful JSON APIs for all modules, centralizing business logic in `server/storage.ts` for automated journal entries, stock movements, and double-entry accounting. Key features include automatic VAT calculations, multi-unit product support, and batch-based inventory.
- **Database**: PostgreSQL via Neon serverless, managed with Drizzle ORM. The schema (`shared/schema.ts`) includes tables for core entities like suppliers, products, invoices, payments, stock, and journal entries, alongside a predefined Chart of Accounts for double-entry accounting.
- **Core Modules**:
    - **Purchases, Inventory & Finance**: Manages procurement, stock, and financial transactions.
    - **Customers/CRM with Loyalty Points**: Profiles, loyalty program, and order history.
    - **Customer Reviews Module**: Feedback tracking with predefined review reasons (positive, negative, neutral), star ratings, order linking, status workflow (pending/reviewed/resolved), and reviewer assignment. Located under Marketing menu.
    - **Cafeteria Module**: Independent inventory and sales with FIFO. Includes ZATCA-compliant credit notes for cancelled orders with return/credit note numbers, stock restoration, and thermal receipt printing with credit note info.
    - **Salon Orders Module**: POS/front desk order management with service/product selection, multi-package support, VAT-inclusive pricing, payment method selection, and loyalty points redemption.
    - **Service Management Module**: CRUD for services, including VAT, related product consumption, employee commission deduction, and multiple image uploads.
    - **Employee Management Module**: Comprehensive HR features covering personal info, salary, payroll, leaves, shifts, attendance, custodies (with full closure audit trail including closure date, reason, notes, closed-by employee, and returned quantity for partial returns), and commission reports.
    - **Commission Management Module**: Employee target-based commission system with configurable profiles tracking services executed, orders created, cafeteria sales, and product sales. Features include automatic deductions for returns and inventory consumption, commission settlement and payment workflows, and detailed activity reports with dates, order numbers, and amounts.
    - **System Settings Module**: Centralized key-value configuration.
    - **Appointments Module**: Mobile app booking with in-salon/home services, GPS tracking, delivery fees, and status workflows.
    - **Chart of Accounts & Financial Reporting**: Manages GL accounts and generates Trial Balance.
    - **Drivers Module**: Manages drivers and delivery trips (appointment-linked or general).
    - **POS Receipt Printing Module**: ZATCA-compliant thermal receipt printing with QR codes and service barcode slips.
    - **Order Returns Module**: ZATCA-compliant returns and credit note system with automatic cancellation returns and journal entry reversals.
    - **Order Payment Journal Entries**: Automatic double-entry accounting for payments, linking payment methods to GL accounts.
    - **Cancelled Order Payment Module**: Revenue recognition for cancelled orders with partial/full payment acceptance and specific revenue account posting.
    - **Interactive Salon Dashboard**: Analytics dashboard with date/source filters, stat cards, sales charts, order distribution, and top performers.
    - **Daily Report Module**: Daily financial analysis, cash reconciliation, revenue breakdown, VAT analysis, and payment method summaries.

## External Dependencies

- **UI & Components**: `@radix-ui/*`, `tailwindcss`, `class-variance-authority`, `clsx`, `lucide-react`, `embla-carousel-react`, `date-fns`.
- **Forms & Validation**: `react-hook-form`, `@hookform/resolvers`, `zod`, `drizzle-zod`.
- **Data Fetching**: `@tanstack/react-query`.
- **Database**: `@neondatabase/serverless`, `drizzle-orm`, `ws`.
- **Backend**: `express`, `cors`, `connect-pg-simple`.
- **Development Tools**: `vite`, `esbuild`, `tsx`, `@replit/*`.
- **External Services**: Neon PostgreSQL Serverless (requires `DATABASE_URL`).